<?php

defined('ABSPATH') || exit;

global $ulz_listing;

$gallery_attrs = Ucore()->jsoning( 'ulz_gallery', $ulz_listing->id );
$size = [
    'ulz_gallery_large',
    'brk_cover_small',
    'ulz_gallery_large',
];
$gallery = [];

foreach( $gallery_attrs as $image_attrs ) {
    if( isset( $image_attrs->id ) ) {
        if( is_array( $size ) ) {
            $gallery_items = [];
            foreach( $size as $size_item ) {
                if( $image = Ucore()->get_image( $image_attrs->id, $size_item ) ) {
                    $gallery_items[ $size_item ] = $image;
                }
            }
            $gallery[] = $gallery_items;
        }else{
            if( $image = Ucore()->get_image( $image_attrs->id, $size ) ) {
                $gallery[] = $image;
            }
        }
    }
}

$gallery_num = count( $gallery );

// Fetch watermark image
$watermark_img = get_option('ulz_watermark_img');
$watermark_img = stripslashes($watermark_img);
$decoded_data = json_decode($watermark_img, true);
$watermark_path = isset($decoded_data[0]['id']) ? wp_get_attachment_url($decoded_data[0]['id']) : '';

?>

<?php if( $gallery && ! empty( $gallery ) ): ?>

    <div class="ulz-cover ulz-cover-adaptive ulz--gallery-lighbox">

        <div class="ulz--images -x<?php echo min( 3, $gallery_num ); ?>">
            <?php foreach( $gallery as $key => $image ): ?>
                <?php if( isset( $image['ulz_gallery_large'] ) ): ?>
                    <div class="ulz--image" style="background-image: url('<?php echo esc_url( $image['ulz_gallery_large'] ); ?>'); position: relative;">
                        <?php if (!empty($watermark_path)): ?>
                            <img class="ulz--watermark" src="<?php echo esc_url($watermark_path); ?>" alt="Watermark" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); pointer-events: none;">
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php if( $key >= 2 ) { break; } ?>
            <?php endforeach; ?>
        </div>

        <ul class="ulz-gallery-stack" style="margin:0;list-style:none;">
            <?php foreach( $gallery as $key => $image ): ?>
                <li class="ulz-gallery" data-image="<?php echo esc_url( $image['ulz_gallery_large'] ); ?>"></li>
            <?php endforeach; ?>
        </ul>
        
        <?php if( count( $gallery ) > 3 ): ?>
            <ul class="ulz-gallery-actions ulz--bottom">
                <li>
                    <a href="#" data-action="expand-gallery">
                        <i class="material-icons">collections</i>
                        <span><?php echo sprintf( esc_html__( '+%s', 'heilz' ), count( $gallery ) - 3 ); ?></span>
                    </a>
                </li>
            </ul>
        <?php endif; ?>

    </div> <!-- cover -->

<?php endif; ?>